float4x4 mWorldViewProj;
float gTime;
float4 gProtoParticle[4];
float gParticleSize;

struct VS_OUTPUT
{
    float4 Position		: POSITION;   // vertex position 
    float2 uv			: TEXCOORD0;
    float4 color : COLOR;
};

#define PI 3.14159265354



VS_OUTPUT main( in float4 pos : POSITION,
				in float2 uv : TEXCOORD0)
{
	VS_OUTPUT Output;
	
	float2 uvlookup[4] = {
		{0.0f, 0.0f},
		{1.0f, 0.0f},
		{1.0f, 1.0f},
		{0.0f, 1.0f}
	};
	
	float particleIndex = pos.x;
	float vertIndex = pos.y;
	float radius = fmod(pos.z+gTime*0.001f*0.2f, 1.0f);
	float invradius = 1.0f-radius;
	float startAngle = uv.x;
	float y = uv.y;
	float speed = invradius*invradius + (1.0f-y)*(1.0f-y);
	float angle = startAngle + speed*gTime*0.001f*0.5f;
	
	pos.x = cos(angle)*radius;
	pos.y = y*0.4f;
	pos.z = sin(angle)*radius;
	pos.w = 1.0f;
	
	float size = 0.015f * gParticleSize;
	pos += gProtoParticle[vertIndex] * size;
	
    Output.Position = mul(pos, mWorldViewProj);
    Output.uv = uvlookup[vertIndex];
    
    float alpha = 1.0f-radius;
    alpha = max(alpha, 0.0f);
    Output.color = (1.0f, 1.0f, 1.0f, alpha);
    
    return Output;
}